
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/reimu.zip" ),
	Asset( "IMAGE", "images/reimutab.tex"),
        Asset( "ATLAS", "images/reimutab.xml"),
	Asset( "IMAGE", "images/reimu1.tex"),
        Asset( "ATLAS", "images/reimu1.xml"),
	Asset("IMAGE", "images/inventoryimages/lf.tex"),
	Asset("ATLAS", "images/inventoryimages/lf.xml"),
	Asset("IMAGE", "images/inventoryimages/yyy.tex"),
	Asset("ATLAS", "images/inventoryimages/yyy.xml"),
	Asset("IMAGE", "images/inventoryimages/qmb.tex"),
	Asset("ATLAS", "images/inventoryimages/qmb.xml"),
	Asset("IMAGE", "images/inventoryimages/black_box.tex"),
	Asset("ATLAS", "images/inventoryimages/black_box.xml"),
	Asset("IMAGE", "images/inventoryimages/lightarmor.tex"),
	Asset("ATLAS", "images/inventoryimages/lightarmor.xml"),
	Asset("IMAGE", "images/inventoryimages/frozen_heart.tex"),
	Asset("ATLAS", "images/inventoryimages/frozen_heart.xml"),
	Asset("IMAGE", "images/inventoryimages/mushasword.tex"),
	Asset("ATLAS", "images/inventoryimages/mushasword.xml"),
	Asset("IMAGE", "images/inventoryimages/mushasword2.tex"),
	Asset("ATLAS", "images/inventoryimages/mushasword2.xml"),
	Asset("IMAGE", "images/inventoryimages/mushasword3.tex"),
	Asset("ATLAS", "images/inventoryimages/mushasword3.xml"),
	Asset("IMAGE", "images/inventoryimages/mushasword4.tex"),
	Asset("ATLAS", "images/inventoryimages/mushasword4.xml"),


}


-- һʾ modʲôߣ ʱҪδá
local prefabs = 
{
    "lf",
    "qmb",
    "yyy",
    "black_box",
    "lightarmor",
    "frozen_heart",
    "firesword1",
    "mushasword",
    "mushasword2",
    "mushasword3",
    "mushasword4",

}
-- һʾ ϷԴʲô ܲ
local start_inv = { "qmb","lf","yyy","black_box","lightarmor","mushasword",}

local function applyupgrades(inst)

    local max_upgrades = 100
    local upgrades = math.min(inst.level, max_upgrades)

    local hunger_percent = inst.components.hunger:GetPercent()
    local health_percent = inst.components.health:GetPercent()
    local sanity_percent = inst.components.sanity:GetPercent()

    inst.components.hunger.max = math.ceil (100 + upgrades * 0.6)
    inst.components.sanity.max = math.ceil (200 + upgrades * 0.5)
    inst.components.health.maxhealth = math.ceil (100 + upgrades * 1.2)
    inst.components.talker:Say("ǰȼ".. (inst.level))
    
    if inst.level >99 then
        inst.components.talker:Say("Ѿ˼!")
    end

    inst.components.hunger:SetPercent(hunger_percent)
    inst.components.health:SetPercent(health_percent)
    inst.components.sanity:SetPercent(sanity_percent)
end

local function oneat(inst, food)
    local summonchance1 = 0.2  
    local summonchance2 = 0.02

    if math.random() < summonchance1 and food and food.components.edible and food.prefab == "frozen_heart" then
 -- if math.random() < summonchance1 and food and food.components.edible.food == "FROZEN_HEART" then
        inst.level = inst.level + 1
        applyupgrades(inst) 
        inst.components.sanity:DoDelta(inst.components.sanity.max*0.5)
        inst.components.health:DoDelta(inst.components.health.maxhealth*0.5)
        inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
        inst.HUD.controls.status.heart:PulseGreen()
        inst.HUD.controls.status.stomach:PulseGreen()
        inst.HUD.controls.status.brain:PulseGreen()
        
        inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
    end
    
    if math.random() < summonchance2 and food then
        inst.components.sanity:DoDelta(inst.components.sanity.max)
        inst.components.health:DoDelta(inst.components.health.maxhealth)
        inst.components.talker:Say("pika,pika~")
    end
end

local function updatestats(inst)
	if GetClock():IsDay() and not GetWorld():IsCave() then
		inst.components.hunger:DoDelta(-inst.components.hunger.max*0.33)
		inst.components.sanity:DoDelta(-inst.components.sanity.max*0.15)
		inst.components.combat.damagemultiplier = 1
		inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED*0.9
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED*0.9
 	elseif GetClock():IsDusk() and not GetWorld():IsCave() then
		inst.components.combat.damagemultiplier = 1.1
		inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
	elseif GetClock():IsNight() and not GetWorld():IsCave() then
		inst.components.combat.damagemultiplier = 1.2
		inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED*1.1
		inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED*1.1
	end
end

local function onpreload(inst, data)
    if data then
        if data.level then
            inst.level = data.level
            applyupgrades(inst)
            --re-set these from the save data, because of load-order clipping issues
            if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
            if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
            if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
            inst.components.health:DoDelta(0)
            inst.components.hunger:DoDelta(0)
            inst.components.sanity:DoDelta(0)
        end
    end
end

local function onsave(inst, data)
	data.level = inst.level
	data.charge_time = inst.charge_time
end

 
local fn = function(inst)
	
	inst.soundsname = "willow"
	inst:AddComponent("reader")
	inst.MiniMapEntity:SetIcon( "reimu1.tex" )

	inst.level = 0

	inst.components.eater.ignoresspoilage = true
	table.insert(inst.components.eater.foodprefs, "FROZEN_HERET")
	table.insert(inst.components.eater.ablefoods, "FROZEN_HERET")
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)

	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8
	inst.components.combat.damagemultiplier = 1.1
	inst.components.inventory:GuaranteeItems({"black_box"})

	inst.components.sanity.night_drain_mult = 1.2
	inst.components.sanity.neg_aura_mult = 1.2
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)

	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	
	inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())
	inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())
	inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())
	updatestats(inst)

	STRINGS.TABS.reimuTABS = ""
	local reimutab = {str = STRINGS.TABS.reimuTABS, sort = 999, icon = "reimutab.tex", icon_atlas = "images/reimutab.xml"}
	inst.components.builder:AddRecipeTab(reimutab)

	local lf = Recipe("lf", {Ingredient("nightmarefuel", 5), Ingredient("slurtleslime", 5), Ingredient("nitre", 15), Ingredient("glommerfuel", 5)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0}, nil, nil, nil, 1)
	lf.atlas = "images/inventoryimages/lf.xml"
	local qmb = Recipe("qmb", {Ingredient("glommerwings", 2), Ingredient("cane", 1), Ingredient("goldnugget", 2), Ingredient("nightmarefuel", 1)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	qmb.atlas = "images/inventoryimages/qmb.xml"

	local yyy = Recipe("yyy", {Ingredient("redgem", 1), Ingredient("goldnugget", 5), Ingredient("nightmarefuel", 2), Ingredient("lightninggoathorn", 1)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	yyy.atlas = "images/inventoryimages/yyy.xml"

-- 鹫ģ

	local mushasword = Recipe("mushasword", {Ingredient("spear", 1), Ingredient("houndstooth", 2), Ingredient("goldnugget", 2)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	mushasword.atlas = "images/inventoryimages/mushasword.xml"

	local mushasword2 = Recipe("mushasword2", {Ingredient("mushasword", 1), Ingredient("goldnugget", 10), Ingredient("frozen_heart", 10)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	mushasword2.atlas = "images/inventoryimages/mushasword2.xml"

	local mushasword3 = Recipe("mushasword3", {Ingredient("mushasword2", 1), Ingredient("goldnugget", 20), Ingredient("frozen_heart", 20)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	mushasword3.atlas = "images/inventoryimages/mushasword3.xml"

	local mushasword4 = Recipe("mushasword4", {Ingredient("mushasword2", 1), Ingredient("goldnugget", 20), Ingredient("frozen_heart", 20)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	mushasword4.atlas = "images/inventoryimages/mushasword4.xml"




	local lightarmor = Recipe("lightarmor", {Ingredient("transistor", 5), Ingredient("nitre", 2), Ingredient("armorwood", 1)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
        lightarmor.atlas = "images/inventoryimages/lightarmor.xml"

	local frozen_heart = Recipe("frozen_heart", {Ingredient("meat", 2), Ingredient("goldnugget", 2)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
        frozen_heart.atlas = "images/inventoryimages/frozen_heart.xml"

	local black_box = Recipe("black_box", {Ingredient("redgem", 1), Ingredient("papyrus", 2)}, reimutab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
        black_box.atlas = "images/inventoryimages/black_box.xml"



 	TheInput:AddKeyUpHandler(KEY_F12, function()
	     inst.components.talker:Say("ǰȼ".. (inst.level))
    end)
end


-- strings! Any "reimu" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- ΪϷѡĽܡ\nʾе˼
STRINGS.CHARACTER_TITLES.reimu = "Ƥ"
STRINGS.CHARACTER_NAMES.reimu = "reimu"
STRINGS.CHARACTER_DESCRIPTIONS.reimu = "*Се\n*ĳɽ汾£\n*ָԲУר"
STRINGS.CHARACTER_QUOTES.reimu = "\"ԲĿɰ\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.reimu = {}


-- Ϊĳʱ˵Ļ  Ĳ㣬Բʵ䣬 һһעˡ


STRINGS.CHARACTERS.reimu.ANNOUNCE_BOOMERANG  = "ĵС."
STRINGS.CHARACTERS.reimu.ANNOUNCE_CHARLIE  = "ҿ?"
STRINGS.CHARACTERS.reimu.ANNOUNCE_CHARLIE_ATTACK = ""

STRINGS.CHARACTERS.reimu.ANNOUNCE_COLD  = "ŮҲǻ."
STRINGS.CHARACTERS.reimu.ANNOUNCE_CRAFTING_FAIL  = "ûʮܸ?"
STRINGS.CHARACTERS.reimu.ANNOUNCE_DUSK = "ؼ."
STRINGS.CHARACTERS.reimu.ANNOUNCE_HUNGRY  = "ҪԵ㶫."
STRINGS.CHARACTERS.reimu.ANNOUNCE_HUNT_BEAST_NEARBY = ". "
STRINGS.CHARACTERS.reimu.ANNOUNCE_HUNT_LOST_TRAIL  = "ȥĶ?"
STRINGS.CHARACTERS.reimu.ANNOUNCE_INV_FULL  = "װ. "
STRINGS.CHARACTERS.reimu.ANNOUNCE_KNOCKEDOUT  = "... "
STRINGS.CHARACTERS.reimu.ANNOUNCE_NODANGERSLEEP  = "ȴ˵."
STRINGS.CHARACTERS.reimu.ANNOUNCE_NOHUNGERSLEEP  = "ȳԵ㶫ô."
STRINGS.CHARACTERS.reimu.ANNOUNCE_NODAYSLEEP  = "λ˰."
STRINGS.CHARACTERS.reimu.ANNOUNCE_NO_TRAP  = "Ǻ. "
STRINGS.CHARACTERS.reimu.ANNOUNCE_PECKED  = "Ҫ. "
STRINGS.CHARACTERS.reimu.ANNOUNCE_QUAKE = " S,. "
STRINGS.CHARACTERS.reimu.ANNOUNCE_RESEARCH  = "ѧ㶫. "
STRINGS.CHARACTERS.reimu.ANNOUNCE_TORCH_OUT  = "?"
STRINGS.CHARACTERS.reimu.ANNOUNCE_WORMHOLE  = "Һ."

STRINGS.CHARACTERS.reimu.ANNOUNCE_EAT = {}
STRINGS.CHARACTERS.reimu.ANNOUNCE_EAT.GENERIC  = "ѳ."
STRINGS.CHARACTERS.reimu.ANNOUNCE_EAT.PAINFULL = "Եĺô?"
STRINGS.CHARACTERS.reimu.ANNOUNCE_EAT.SPOILED = "."
STRINGS.CHARACTERS.reimu.ANNOUNCE_EAT.STALE  = "Ѿʼ."

STRINGS.CHARACTERS.reimu.BATTLECRY = {}
STRINGS.CHARACTERS.reimu.BATTLECRY.GENERIC  = "ɢ!"
STRINGS.CHARACTERS.reimu.BATTLECRY.PIG = "Ұ."
STRINGS.CHARACTERS.reimu.BATTLECRY.PREY  = "ΪСҾͲ۸. "
STRINGS.CHARACTERS.reimu.BATTLECRY.SPIDER  = "֩ɢ!"
STRINGS.CHARACTERS.reimu.BATTLECRY.SPIDER_WARRIOR  = "ǱȽ鷳һ."
STRINGS.CHARACTERS.reimu.BATTLECRY.HOUND  = "."
STRINGS.CHARACTERS.reimu.BATTLECRY.LEIF  = "ô?"

-- Description
STRINGS.CHARACTERS.reimu.DESCRIBE = {}
STRINGS.CHARACTERS.reimu.DESCRIBE.ROBIN = "̫ഺҲð."
STRINGS.CHARACTERS.reimu.DESCRIBE.SLURPER  = "Ҫɢ?"
STRINGS.CHARACTERS.reimu.DESCRIBE.ORANGEAMULET  = "ҲħɳȽϸȤ."
STRINGS.CHARACTERS.reimu.DESCRIBE.YELLOWSTAFF  = "ҲħɳȽϸȤ."
STRINGS.CHARACTERS.reimu.DESCRIBE.YELLOWGEM  = "Ʊʯ,ʮ? "
STRINGS.CHARACTERS.reimu.DESCRIBE.ORANGEGEM  = "ȱʯ,ʮ?"
STRINGS.CHARACTERS.reimu.DESCRIBE.STAFFLIGHT  = "û."
STRINGS.CHARACTERS.reimu.DESCRIBE.ANCIENT_ALTAR  = "𲻺."
STRINGS.CHARACTERS.reimu.DESCRIBE.CAVE_BANANA  = "һ㽶."
STRINGS.CHARACTERS.reimu.DESCRIBE.ROCKY  = "ɶ?"
STRINGS.CHARACTERS.reimu.DESCRIBE.EVERGREEN = "ϣûз˵."


return MakePlayerCharacter("reimu", prefabs, assets, fn, start_inv)